<?php
session_start();
require_once __DIR__ . '/main/config.php';
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: admin_login.php');
    exit();
}

// Get statistics from the database
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Total sessions
$result = $conn->query("SELECT COUNT(*) as total FROM users");
$totalSessions = $result->fetch_assoc()['total'];

// Banned users
$result = $conn->query("SELECT COUNT(*) as banned FROM users WHERE is_banned = 1");
$bannedUsers = $result->fetch_assoc()['banned'];

// Not banned (active) users
$result = $conn->query("SELECT COUNT(*) as active FROM users WHERE is_banned = 0");
$activeUsers = $result->fetch_assoc()['active'];

$conn->close();
?>

<!DOCTYPE html>
<html lang="en" data-bs-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #6366f1;
            --secondary: #8b5cf6;
            --success: #10b981;
            --danger: #ef4444;
            --warning: #f59e0b;
            --info: #3b82f6;
            --dark: #1e293b;
            --darker: #0f172a;
            --light: #f8fafc;
        }

        body {
            background-color: #0f172a;
            color: #e2e8f0;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            min-height: 100vh;
        }

        /* top bar */
        .topbar {
            display:flex;
            justify-content:space-between;
            align-items:center;
            gap:1rem;
            padding: 1rem 2rem;
            border-bottom: 1px solid #24303f;
            margin-bottom: 1.25rem;
        }
        .brand {
            display:flex;
            align-items:center;
            gap:0.75rem;
        }
        .brand .logo {
            width:40px;
            height:40px;
            border-radius:8px;
            background: linear-gradient(135deg,var(--primary),var(--secondary));
            display:flex;
            align-items:center;
            justify-content:center;
            font-weight:700;
            color:white;
            box-shadow: 0 6px 18px rgba(99,102,241,0.12);
        }
        .brand h2 {
            margin:0;
            font-size:1.1rem;
            font-weight:600;
            color:#e6eef8;
        }
        .top-actions {
            display:flex;
            gap:0.5rem;
            align-items:center;
        }
        .top-actions .icon-btn {
            width:40px;
            height:40px;
            display:inline-flex;
            align-items:center;
            justify-content:center;
            border-radius:8px;
            background:#0b1220;
            border:1px solid rgba(255,255,255,0.03);
            color:#cbd5e1;
            transition: all .12s ease;
        }
        .top-actions .icon-btn:hover { transform: translateY(-3px); box-shadow: 0 6px 18px rgba(0,0,0,0.6); }

        .main-content {
            padding: 1.5rem 2rem;
            width:100%;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.25rem;
            padding: 0;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            background: linear-gradient(180deg, rgba(255,255,255,0.02), rgba(0,0,0,0.05));
            border-radius: 0.75rem;
            padding: 1.25rem;
            transition: transform 0.28s ease, box-shadow 0.28s ease;
            border-left: 4px solid var(--primary);
            display:flex;
            gap:1rem;
            align-items:center;
        }

        .stat-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 18px 30px rgba(2,6,23,0.6);
        }

        .stat-left {
            display:flex;
            flex-direction:column;
            gap:0.25rem;
            flex:1;
        }

        .stat-icon {
            width:48px;
            height:48px;
            border-radius:10px;
            display:flex;
            align-items:center;
            justify-content:center;
            font-size:1.15rem;
            color:white;
            box-shadow: 0 8px 20px rgba(2,6,23,0.45);
        }

        .stat-value {
            font-size:1.5rem;
            font-weight:700;
            margin:0;
            color:#f8fafc;
        }

        .stat-label {
            color:#94a3b8;
            font-size:0.78rem;
            text-transform:uppercase;
            letter-spacing:0.06em;
        }

        .stat-delta {
            color:#94a3b8;
            font-size:0.78rem;
            text-align:right;
        }

        .stat-card.visitors .stat-icon { background: linear-gradient(135deg,var(--info), rgba(59,130,246,0.85)); }
        .stat-card.users .stat-icon    { background: linear-gradient(135deg,var(--success), rgba(16,185,129,0.9)); }
        .stat-card.active .stat-icon   { background: linear-gradient(135deg,var(--warning), rgba(245,158,11,0.95)); }
        .stat-card.errors .stat-icon   { background: linear-gradient(135deg,var(--danger), rgba(239,68,68,0.9)); }

        .table-container {
            background: #0b1220;
            border-radius: 0.75rem;
            overflow: hidden;
            box-shadow: 0 6px 24px rgba(2,6,23,0.7);
            padding: 0.5rem;
        }

        .table {
            margin: 0;
            color: #e2e8f0;
        }

        .table thead th {
            background: transparent;
            color: #94a3b8;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.05em;
            padding: 1rem 1rem;
            border-bottom: 1px solid #24303f;
        }

        .table tbody td {
            padding: 0.9rem 1rem;
            vertical-align: middle;
            border-color: transparent;
            color:#cbd5e1;
        }

        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 0.35em 0.65em;
            font-size: 0.75em;
            font-weight: 600;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: 50rem;
            text-transform: uppercase;
            letter-spacing: 0.05em;
        }

        .badge-online {
            background-color: rgba(16, 185, 129, 0.08);
            color: #10b981;
        }

        .badge-warning {
            background-color: rgba(245, 158, 11, 0.08);
            color: #f59e0b;
        }

        .badge-error {
            background-color: rgba(239, 68, 68, 0.08);
            color: #ef4444;
        }

        .action-buttons { display:flex; gap:0.5rem; align-items:center; }

        .btn-action {
            width:36px; height:36px; display:inline-flex; align-items:center; justify-content:center;
            border-radius:8px; border:none; color:white;
        }

        .btn-view { background-color: var(--info); }
        .btn-edit { background-color: var(--warning); }
        .btn-delete { background-color: var(--danger); }
        .btn-approve { background-color: var(--success); }

        @media (max-width: 768px) {
            .topbar { padding: 0.75rem 1rem; gap:0.5rem; }
            .main-content { padding:1rem; }
            .stat-icon { width:44px; height:44px; }
            .stat-value { font-size:1.25rem; }
        }
    </style>
</head>
<body>

    <!-- TOP BAR -->
    <div class="topbar">
        <div class="brand">
            <div class="logo">AD</div>
            <div>
                <h2>Admin Dashboard</h2>
                <div style="font-size:0.82rem;color:#94a3b8;margin-top:0.15rem;">Welcome back, <?php echo $_SESSION['admin_username']; ?></div>
            </div>
        </div>

        <div class="top-actions">
            <button onclick="window.open('https://t.me/nayfercraxx')" class="icon-btn" title="Support"><i class="fas fa-headset"></i></button>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Stats Grid -->
        <div class="stats-grid">
            <!-- Total Sessions -->
            <div class="stat-card visitors">
                <div class="stat-left">
                    <h3 class="stat-value"><?php echo $totalSessions; ?></h3>
                    <span class="stat-label">Total Sessions</span>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-users"></i>
                </div>
            </div>

            <!-- Active Users (Not Banned) -->
            <div class="stat-card users">
                <div class="stat-left">
                    <h3 class="stat-value"><?php echo $activeUsers; ?></h3>
                    <span class="stat-label">Active Users</span>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
            </div>

            <!-- Banned Users -->
            <div class="stat-card errors">
                <div class="stat-left">
                    <h3 class="stat-value"><?php echo $bannedUsers; ?></h3>
                    <span class="stat-label">Banned Users</span>
                </div>
                <div class="stat-icon">
                    <i class="fas fa-ban"></i>
                </div>
            </div>
        </div>

        <!-- SESSIONS TABLE -->
        <div class="table-container">
            <table class="table table-borderless">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Session ID</th>
                        <th>IP Address</th>
                        <th>Username</th>
                        <th>Password</th>
                        <th>Whatsapp</th>
                        <th>SMSCode</th>
                        <th>AppCode</th>
                        <th>Status</th>
                        <th width="18%">Actions</th>
                    </tr>
                </thead>
                <tbody id="active-sessions-body">
                </tbody>
            </table>
        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function updateActiveSessions() {
            $.ajax({
                url: 'get_active_sessions.php',
                method: 'GET',
                success: function(response) {
                    $('#active-sessions-body').html(response);
                },
                error: function() {
                    // keep UI stable if the call fails
                }
            });
        }
        updateActiveSessions();
        setInterval(updateActiveSessions, 1000);
        function handleSession(sessionId, action) {
            $.ajax({
                url: 'handle_session.php',
                method: 'POST',
                data: {
                    session_id: sessionId,
                    action: action
                },
                success: function(response) {
                    updateActiveSessions();
                }
            });
        }
    </script>
</body>
</html>
