<?php
session_start();
require_once '../main/config.php';

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Origin, Content-Type, Accept, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 86400");
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
        header('Content-Length: 0');
    exit;
}

try {

    $session_id = $_POST['session_id'] ?? null;
    $is_online = $_POST['online'] ?? null;
    $last_seen = date('Y-m-d H:i:s');

    if (empty($session_id)) {
        throw new Exception('Invalid or missing session_id / online status');
    }

    // Connect DB
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        throw new Exception('Database connection failed');
    }

    // Update status
    $stmt = $conn->prepare("UPDATE users SET is_online = ?, last_seen = ? WHERE session_id = ?");
    // Convert various boolean representations to integer
    $is_online_int = ($is_online === true || $is_online === 1 || $is_online === "true") ? 1 : 0;
    $stmt->bind_param("iss", $is_online_int, $last_seen, $session_id);

    if (!$stmt->execute()) {
        throw new Exception('Failed to update status');
    }

    if ($stmt->affected_rows === 0) {
        throw new Exception('Session not found');
    }

    echo json_encode([
        'success'   => true,
        'session_id'=> $session_id,
        'is_online' => $is_online_int,
        'last_seen' => $last_seen
    ]);

} catch (Exception $e) {
    http_response_code(400);
    file_put_contents(__DIR__ . "/result.log", [
        'success' => false,
        'message' => $e->getMessage()
    ]);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($conn)) $conn->close();
}
