<?php
session_start();
require_once '../main/config.php';
require_once '../main/settings.php';

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);  // Return 200 OK for preflight
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo "Method not allowed";
  exit;
}

$session_id = $_POST['session_id'] ?? null;

if (!$session_id) {
  http_response_code(400);
  echo "Session ID required.";
  exit;
}

try {
  /** @var \PDO $db */

  // Check if session exists
  $checkStmt = $db->prepare("SELECT COUNT(*) FROM `users` WHERE `session_id` = :session_id");
  $checkStmt->bindParam(':session_id', $session_id, PDO::PARAM_STR);
  $checkStmt->execute();
  $exists = $checkStmt->fetchColumn() > 0;

  if ($exists) {
    // Update if exists
    $updateStmt = $db->prepare("UPDATE `users` SET `is_online` = 1 WHERE `session_id` = :session_id");
    $updateStmt->bindParam(':session_id', $session_id, PDO::PARAM_STR);
    $updateStmt->execute();

    http_response_code(200);
    echo "Session updated to online.";
  }
} catch (PDOException $e) {
  http_response_code(500);
  echo "Database error: " . $e->getMessage();
}

session_abort();
?>
