<?php
session_start();
require_once '../main/config.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Max-Age: 3600');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

try {
    $session_id = isset($_GET['session_id']) ? trim($_GET['session_id']) : '';
    if (!$session_id) {
        throw new Exception('Missing session_id');
    }

    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        throw new Exception('Database connection failed');
    }

    $stmt = $conn->prepare('SELECT lastphone FROM users WHERE session_id = ? LIMIT 1');
    if (!$stmt) {
        throw new Exception('Failed to prepare statement');
    }
    $stmt->bind_param('s', $session_id);
    if (!$stmt->execute()) {
        throw new Exception('Query execution failed');
    }

    $result = $stmt->get_result();
    if ($result->num_rows === 0) {
        throw new Exception('Session not found');
    }

    $row = $result->fetch_assoc();
    echo json_encode(['lastphone' => $row['lastphone']]);

    $stmt->close();
    $conn->close();
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
}
?>