<?php
session_start();
require_once '../main/config.php';
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600");
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

try {
    $user_ip = $_SERVER['REMOTE_ADDR'] ?? '';

    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

    if ($conn->connect_error) {
        throw new Exception('Database connection failed');
    }

    $stmt = $conn->prepare("SELECT is_banned FROM users WHERE ip = ? AND is_banned = 1 LIMIT 1");
    $stmt->bind_param("s", $user_ip);

    if (!$stmt->execute()) {
        throw new Exception('Failed to check status');
    }

    $result = $stmt->get_result();
    $user = $result->fetch_assoc();


    echo json_encode(!$user ? ['status' => 'not_banned'] : ['status' => 'banned']);


} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($conn)) $conn->close();
}
