<?php
session_start();
require_once '../main/config.php';
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600");
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

try {
    $session_id = $_POST['session_id'] ?? null;
    
    if (!$session_id) {
        throw new Exception('Invalid session');
    }

    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        throw new Exception('Database connection failed');
    }

    $last_seen = date('Y-m-d H:i:s');
    $stmt = $conn->prepare("UPDATE users SET is_online = 1, last_seen = ? WHERE session_id = ?");
    $stmt->bind_param("ss", $last_seen, $session_id);
    
    if (!$stmt->execute()) {
        throw new Exception('Failed to update heartbeat');
    }

    if ($stmt->affected_rows === 0) {
        throw new Exception('Session not found');
    }

    echo json_encode([
        'success' => true,
        'last_seen' => $last_seen
    ]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($conn)) $conn->close();
}
?>
