<?php
session_start();
require_once '../main/config.php';
require_once '../main/settings.php';

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo "Method not allowed";
    exit;
}

$session_id = $_POST['session_id'] ?? null;

if (!$session_id) {
    http_response_code(400);
    echo "Session ID required.";
    exit;
}

try {
    /** @var \PDO $db */
    $stmt = $db->prepare("UPDATE `users` SET `is_online` = 0 WHERE `session_id` = :session_id");
    $stmt->bindParam(':session_id', $session_id, PDO::PARAM_STR);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        http_response_code(200);
        echo "Session status updated to offline.";
    } else {
        http_response_code(404);
        echo "Session not found.";
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo "Database error: " . $e->getMessage();
}

session_abort();
?>
