<?php
session_start();
require_once '../main/config.php';
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 3600");
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

try {
    $session_id = isset($_GET['session_id']) ? trim($_GET['session_id']) : ($_SESSION['session_id'] ?? '');

    if (!$session_id) {
        throw new Exception('Invalid session');
    }

    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        throw new Exception('Database connection failed');
    }

    $stmt = $conn->prepare("SELECT status FROM users WHERE session_id = ? LIMIT 1");
    $stmt->bind_param("s", $session_id);
    
    if (!$stmt->execute()) {
        throw new Exception('Failed to check status');
    }

    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if (!$user) {
        throw new Exception('Session not found');
    }


    $response = [
        'status' => $user['status'],
    ];

    echo json_encode($response);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
} finally {
    if (isset($stmt)) $stmt->close();
    if (isset($conn)) $conn->close();
}