<?php
session_start();
require_once './main/config.php';

if (isset($_SESSION['admin_logged_in'])) {
    header('Location: index.php');
    exit();
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Simple check against config constants
    if ($username === ADMIN_USERNAME && $password === ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_username'] = $username;
        $_SESSION['login_time'] = time();
        header('Location: index.php');
        exit();
    } else {
        $error = 'Invalid username or password';
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Admin Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html, body {
            height: 100%;
            margin: 0;
            background: #1a1a1a; /* Dark background to match your screenshot */
        }

        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            position: fixed; /* Prevents scrolling */
            width: 100%;
            overflow: hidden; /* Prevents scrolling */
        }

        .login-container {
            width: 100%;
            max-width: 400px;
            padding: 2rem;
            background: #2b2b2b; /* Dark container background */
            border-radius: 12px;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
        }

        .logo {
            text-align: center;
            margin-bottom: 2rem;
        }

        .logo h2 {
            color: #ffffff;
            font-size: 24px;
            font-weight: 500;
            margin: 0;
        }

        .form-label {
            color: #ffffff;
            font-size: 14px;
            margin-bottom: 8px;
            display: block;
        }

        .form-control {
            width: 100%;
            padding: 12px;
            background: #333333;
            border: 1px solid #404040;
            border-radius: 6px;
            color: #ffffff;
            margin-bottom: 16px;
            font-size: 14px;
        }

        .form-control:focus {
            outline: none;
            border-color: #0066cc;
            box-shadow: 0 0 0 2px rgba(0, 102, 204, 0.2);
        }

        .form-control::placeholder {
            color: #666666;
        }

        .btn-primary {
            width: 100%;
            padding: 12px;
            background: #0066cc;
            border: none;
            border-radius: 6px;
            color: #ffffff;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .btn-primary:hover {
            background: #0052a3;
        }

        .error-message {
            background: rgba(220, 53, 69, 0.1);
            color: #ff6b6b;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 16px;
            text-align: center;
            font-size: 14px;
        }

        /* Ensure form is centered on all devices */
        @media (max-width: 480px) {
            .login-container {
                width: 90%;
                padding: 1.5rem;
            }
        }

        /* Prevent zoom on iOS */
        @media (max-width: 768px) {
            input[type="text"],
            input[type="password"] {
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <h2>Admin Panel</h2>
        </div>
        <?php if ($error): ?>
            <div class="error-message">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        <form method="POST" action="">
            <div class="form-group">
                <label for="username" class="form-label">Username</label>
                <input type="text" 
                       class="form-control" 
                       id="username" 
                       name="username" 
                       required 
                       autocomplete="off" 
                       placeholder="Enter username">
            </div>
            <div class="form-group">
                <label for="password" class="form-label">Password</label>
                <input type="password" 
                       class="form-control" 
                       id="password" 
                       name="password" 
                       required 
                       placeholder="Enter password">
            </div>
            <button type="submit" class="btn btn-primary">Login</button>
        </form>
    </div>

    <script>
        // Clear form on page load
        window.onload = function() {
            document.getElementById('username').value = '';
            document.getElementById('password').value = '';
        };
    </script>
</body>
</html>